/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.io;

import com.medfli.model.PictureInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public final class Plus4MultiImporter {
    private static final int LUMA_BASE = 30720;
    private static final int COLOR_BASE = 31744;
    private static final int BITMAP_BASE = 32768;
    private static final int MAGIC_ADDR = 31738;
    private static final int SCREEN_W_PIX = 160;
    private static final int SCREEN_H_PIX = 200;
    private static final int CHAR_W = 40;
    private static final int CHAR_H = 25;

    private Plus4MultiImporter() {
    }

    public static void importMulti(PictureInfo pic, File file) throws IOException {
        byte[] mem = Plus4MultiImporter.loadToMemory(file);
        if (!Plus4MultiImporter.hasMultiSignature(mem)) {
            throw new IOException("Selected file does not contain MULT multicolor signature at $7BFA.");
        }
        Plus4MultiImporter.applyMultiToPicture(pic, mem);
    }

    public static void importMultiBotticelli(PictureInfo pic, File file) throws IOException {
        Plus4MultiImporter.importMulti(pic, file);
    }

    public static void importIstvanvMulticolor(PictureInfo pic, File file) throws IOException {
        Plus4MultiImporter.importMulti(pic, file);
    }

    private static void applyMultiToPicture(PictureInfo pic, byte[] mem) {
        int cx;
        int ff16Raw = mem[31742] & 0xFF;
        int ff15Raw = mem[31743] & 0xFF;
        int ff16 = Plus4MultiImporter.nibbleSwap(ff16Raw);
        int ff15 = Plus4MultiImporter.nibbleSwap(ff15Raw);
        byte[] ff15Line = pic.getFF15Line();
        byte[] ff16Line = pic.getFF16Line();
        for (int y = 0; y < 200; ++y) {
            ff15Line[y] = (byte)ff15;
            ff16Line[y] = (byte)ff16;
        }
        byte[] bmp = new byte[8000];
        int bi = 0;
        for (int row = 0; row < 25; ++row) {
            for (cx = 0; cx < 40; ++cx) {
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int addr = 32768 + row * 320 + cx * 8 + yInChar;
                    bmp[bi++] = mem[addr];
                }
            }
        }
        Plus4MultiImporter.fillPixelsFromPlus4Bitmap(pic, bmp);
        for (int cy = 0; cy < 25; ++cy) {
            for (cx = 0; cx < 40; ++cx) {
                int off = cy * 40 + cx;
                int lumB = mem[30720 + off] & 0xFF;
                int chrB = mem[31744 + off] & 0xFF;
                int aux0L = lumB >> 4 & 0xF;
                int aux1L = lumB & 0xF;
                int aux1C = chrB >> 4 & 0xF;
                int aux0C = chrB & 0xF;
                int idx0 = (aux0L &= 7) << 4 | aux0C & 0xF;
                int idx1 = (aux1L &= 7) << 4 | aux1C & 0xF;
                int baseX = cx * 4;
                int baseY = cy * 8;
                for (int dy = 0; dy < 8; ++dy) {
                    int y = baseY + dy;
                    if (y < 0 || y >= 200) continue;
                    for (int dx = 0; dx < 4; ++dx) {
                        int x = baseX + dx;
                        if (x < 0 || x >= 160) continue;
                        pic.setAuxColorAt(x, y, 0, idx0);
                        pic.setAuxColorAt(x, y, 1, idx1);
                    }
                }
            }
        }
    }

    private static void fillPixelsFromPlus4Bitmap(PictureInfo pic, byte[] packed) {
        int i = 0;
        for (int row = 0; row < 25; ++row) {
            for (int xChar = 0; xChar < 40; ++xChar) {
                int x = xChar * 4;
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int b = packed[i++] & 0xFF;
                    int y = row * 8 + yInChar;
                    pic.setPixel2bpp(x, y, (byte)(b >> 6 & 3));
                    pic.setPixel2bpp(x + 1, y, (byte)(b >> 4 & 3));
                    pic.setPixel2bpp(x + 2, y, (byte)(b >> 2 & 3));
                    pic.setPixel2bpp(x + 3, y, (byte)(b & 3));
                }
            }
        }
    }

    private static byte[] loadToMemory(File file) throws IOException {
        byte[] raw = Files.readAllBytes(file.toPath());
        byte[] mem = new byte[65536];
        if (raw.length >= 2) {
            int loadAddr = (raw[1] & 0xFF) << 8 | raw[0] & 0xFF;
            int dataLen = raw.length - 2;
            if (loadAddr > 0 && loadAddr + dataLen <= 65536) {
                System.arraycopy(raw, 2, mem, loadAddr, dataLen);
                return mem;
            }
        }
        int maxCopy = Math.min(raw.length, mem.length - 30720);
        System.arraycopy(raw, 0, mem, 30720, maxCopy);
        return mem;
    }

    private static boolean hasMultiSignature(byte[] mem) {
        return (mem[31738] & 0xFF) == 77 && (mem[31739] & 0xFF) == 85 && (mem[31740] & 0xFF) == 76 && (mem[31741] & 0xFF) == 84;
    }

    private static int nibbleSwap(int v) {
        int lo = v & 0xF;
        int hi = v >> 4 & 0xF;
        return lo << 4 | hi;
    }
}

