/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.io;

import com.medfli.model.PictureInfo;
import com.medfli.model.Plus4Palette;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Locale;
import javax.imageio.ImageIO;

public final class PrgExporter {
    private static final int LOAD_ADDR = 4097;
    private static final int END_ADDR = 24576;
    private static final int BITMAP_START = 8384;
    private static final int BITMAP_END = 16383;
    private static final int FF14_LUMA0 = 16408;
    private static final int FF14_CHROMA0 = 17432;
    private static final int FF14_LUMA1 = 18456;
    private static final int FF14_CHROMA1 = 19480;
    private static final int FF14_LUMA2 = 20504;
    private static final int FF14_CHROMA2 = 21528;
    private static final int FF14_LUMA3 = 22552;
    private static final int FF14_CHROMA3 = 23576;
    private static final int FF15_BASE = 6656;
    private static final int FF16_BASE = 6912;
    private static final int SCREEN_W_CHARS = 40;
    private static final int CHAR_HEIGHT = 8;
    private static final int PIX_W = 160;
    private static final int PIX_H = 200;

    private PrgExporter() {
    }

    public static void exportPRG(PictureInfo pic, File file) throws IOException {
        int load = 4097;
        int end = 24576;
        int total = 20480;
        byte[] mem = new byte[20480];
        for (int y = 0; y < 200; ++y) {
            mem[2559 + y] = pic.getFF15Line()[y];
            mem[2815 + y] = pic.getFF16Line()[y];
        }
        int offBmp = 4287;
        int i = 0;
        for (int row = 0; row < 25; ++row) {
            for (int xChar = 0; xChar < 40; ++xChar) {
                int x = xChar * 4;
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int y = row * 8 + yInChar;
                    int p0 = pic.getPixel2bpp(x, y) & 3;
                    int p1 = pic.getPixel2bpp(x + 1, y) & 3;
                    int p2 = pic.getPixel2bpp(x + 2, y) & 3;
                    int p3 = pic.getPixel2bpp(x + 3, y) & 3;
                    mem[offBmp + i++] = (byte)(p0 << 6 | p1 << 4 | p2 << 2 | p3);
                }
            }
        }
        int[] LUMA_BASE = new int[]{16408, 18456, 20504, 22552};
        int[] CHROMA_BASE = new int[]{17432, 19480, 21528, 23576};
        for (int band = 0; band < 4; ++band) {
            int baseL = LUMA_BASE[band] - 4097;
            int baseC = CHROMA_BASE[band] - 4097;
            for (int rowPair = 0; rowPair < 25; ++rowPair) {
                int y0 = rowPair * 8 + band * 2;
                int rowOff = rowPair * 40;
                for (int xChar = 0; xChar < 40; ++xChar) {
                    int px = xChar * 4;
                    int[] aux = pic.getAuxColorsAt(px, y0);
                    int idx1 = aux[0] & 0xFF;
                    int idx2 = aux[1] & 0xFF;
                    int aux1L = idx1 / 16 & 7;
                    int aux1C = idx1 % 16 & 0xF;
                    int aux2L = idx2 / 16 & 7;
                    int aux2C = idx2 % 16 & 0xF;
                    int lumByte = (aux1L & 0xF) << 4 | aux2L & 0xF;
                    int chrByte = (aux2C & 0xF) << 4 | aux1C & 0xF;
                    mem[baseL + rowOff + xChar] = (byte)lumByte;
                    mem[baseC + rowOff + xChar] = (byte)chrByte;
                }
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(1);
            fos.write(16);
            fos.write(mem);
        }
    }

    public static void exportUsingIoTemplate(PictureInfo pic, File outPrg, File outAsm) throws IOException {
        byte[] tpl = PrgExporter.loadIoTemplate();
        if (tpl.length < 2) {
            throw new IOException("Template PRG too short.");
        }
        int loadAddr = (tpl[1] & 0xFF) << 8 | tpl[0] & 0xFF;
        if (loadAddr != 4097) {
            throw new IOException(String.format("Unexpected template load address: $%04X (expected $%04X)", loadAddr, 4097));
        }
        for (int y = 0; y < 200; ++y) {
            int off15 = PrgExporter.prgOffset(loadAddr, 6656 + y);
            int off16 = PrgExporter.prgOffset(loadAddr, 6912 + y);
            if (off15 >= 2 && off15 < tpl.length) {
                tpl[off15] = pic.getFF15Line()[y];
            }
            if (off16 < 2 || off16 >= tpl.length) continue;
            tpl[off16] = pic.getFF16Line()[y];
        }
        for (int row = 0; row < 25; ++row) {
            for (int xChar = 0; xChar < 40; ++xChar) {
                int x = xChar * 4;
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int y = row * 8 + yInChar;
                    int p0 = pic.getPixel2bpp(x, y) & 3;
                    int p1 = pic.getPixel2bpp(x + 1, y) & 3;
                    int p2 = pic.getPixel2bpp(x + 2, y) & 3;
                    int p3 = pic.getPixel2bpp(x + 3, y) & 3;
                    int addr = 8384 + row * 320 + xChar * 8 + yInChar;
                    int ofs = PrgExporter.prgOffset(loadAddr, addr);
                    if (ofs < 2 || ofs >= tpl.length) continue;
                    tpl[ofs] = (byte)(p0 << 6 | p1 << 4 | p2 << 2 | p3);
                }
            }
        }
        int[] LUMA_BASE = new int[]{16408, 18456, 20504, 22552};
        int[] CHROMA_BASE = new int[]{17432, 19480, 21528, 23576};
        for (int band = 0; band < 4; ++band) {
            int baseL = LUMA_BASE[band];
            int baseC = CHROMA_BASE[band];
            for (int rowPair = 0; rowPair < 25; ++rowPair) {
                int y0 = rowPair * 8 + band * 2;
                int rowOff = rowPair * 40;
                for (int xChar = 0; xChar < 40; ++xChar) {
                    int px = xChar * 4;
                    int[] aux = pic.getAuxColorsAt(px, y0);
                    int idx1 = aux[0] & 0xFF;
                    int idx2 = aux[1] & 0xFF;
                    int aux1L = idx1 / 16 & 7;
                    int aux1C = idx1 % 16 & 0xF;
                    int aux2L = idx2 / 16 & 7;
                    int aux2C = idx2 % 16 & 0xF;
                    int lumByte = (aux1L & 0xF) << 4 | aux2L & 0xF;
                    int chrByte = (aux2C & 0xF) << 4 | aux1C & 0xF;
                    int ofsL = PrgExporter.prgOffset(loadAddr, baseL + rowOff + xChar);
                    int ofsC = PrgExporter.prgOffset(loadAddr, baseC + rowOff + xChar);
                    if (ofsL >= 2 && ofsL < tpl.length) {
                        tpl[ofsL] = (byte)(lumByte & 0xFF);
                    }
                    if (ofsC < 2 || ofsC >= tpl.length) continue;
                    tpl[ofsC] = (byte)(chrByte & 0xFF);
                }
            }
        }
        try (FileOutputStream fos = new FileOutputStream(outPrg);){
            fos.write(tpl);
        }
        PrgExporter.writeAsm(pic, outAsm);
        PrgExporter.writePngPreview(pic, outPrg);
    }

    private static int prgOffset(int loadAddr, int targetAddr) {
        return 2 + (targetAddr - loadAddr);
    }

    private static byte[] loadIoTemplate() throws IOException {
        String cp = "/com/medfli/io/dfli.prg";
        try (InputStream in = PrgExporter.class.getResourceAsStream(cp);){
            if (in != null) {
                byte[] data = in.readAllBytes();
                System.out.println("Loaded DFLI template from resource: " + cp);
                byte[] byArray = data;
                return byArray;
            }
        }
        File f = new File("io/dfli.prg");
        if (f.isFile()) {
            return Files.readAllBytes(f.toPath());
        }
        throw new FileNotFoundException("Missing template: io/dfli.prg (or classpath " + cp + ")");
    }

    private static void writeAsm(PictureInfo pic, File outAsm) throws IOException {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outAsm), "UTF-8"));){
            pw.println("; Auto-generated by MeDFLIstvan - with memory address recommendations");
            pw.println("; BYTE tables for CBM PRG Studio (8 bytes/line)");
            pw.println();
            pw.printf("; FF15 ($%04X-$%04X)\n", 6656, 6855);
            pw.println("FF15_datas");
            PrgExporter.dumpLinear200Asm(pw, pic.getFF15Line());
            pw.printf("; FF16 ($%04X-$%04X)\n", 6912, 7111);
            pw.println("FF16_datas");
            PrgExporter.dumpLinear200Asm(pw, pic.getFF16Line());
            pw.println();
            pw.printf("; Bitmap ($%04X-$%04X)\n", 8384, 16383);
            pw.println("Bitmap_datas");
            PrgExporter.dumpBitmapAsm(pw, pic);
            PrgExporter.dumpFF14Asm(pw, pic, "FF14_1", 16408, 17432, 0);
            PrgExporter.dumpFF14Asm(pw, pic, "FF14_2", 18456, 19480, 1);
            PrgExporter.dumpFF14Asm(pw, pic, "FF14_3", 20504, 21528, 2);
            PrgExporter.dumpFF14Asm(pw, pic, "FF14_4", 22552, 23576, 3);
        }
    }

    private static void dumpLinear200Asm(PrintWriter pw, byte[] arr) {
        int n = 0;
        StringBuilder line = new StringBuilder("BYTE ");
        for (int i = 0; i < 200; ++i) {
            int v = arr[i] & 0xFF;
            if (n == 8) {
                pw.println(line);
                line.setLength(0);
                line.append("BYTE ");
                n = 0;
            }
            if (n > 0) {
                line.append(',');
            }
            line.append(PrgExporter.hex(v));
            ++n;
        }
        if (n > 0) {
            pw.println(line);
        }
        pw.println();
    }

    private static void dumpBitmapAsm(PrintWriter pw, PictureInfo pic) {
        int count = 0;
        StringBuilder line = new StringBuilder("BYTE ");
        for (int row = 0; row < 25; ++row) {
            for (int xChar = 0; xChar < 40; ++xChar) {
                int x = xChar * 4;
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int y = row * 8 + yInChar;
                    int p0 = pic.getPixel2bpp(x, y) & 3;
                    int p1 = pic.getPixel2bpp(x + 1, y) & 3;
                    int p2 = pic.getPixel2bpp(x + 2, y) & 3;
                    int p3 = pic.getPixel2bpp(x + 3, y) & 3;
                    int packed = p0 << 6 | p1 << 4 | p2 << 2 | p3;
                    if (count == 8) {
                        pw.println(line);
                        line.setLength(0);
                        line.append("BYTE ");
                        count = 0;
                    }
                    if (count > 0) {
                        line.append(',');
                    }
                    line.append(PrgExporter.hex(packed));
                    ++count;
                }
            }
        }
        if (count > 0) {
            pw.println(line);
        }
        pw.println();
    }

    private static void dumpFF14Asm(PrintWriter pw, PictureInfo pic, String label, int baseLuma, int baseChroma, int band) {
        pw.printf("; %s LUMA  ($%04X-...)\n", label, baseLuma);
        pw.println(label + "_LUMA_datas");
        PrgExporter.dumpFF14BandAsm(pw, pic, band, true);
        pw.printf("; %s CHROMA($%04X-...)\n", label, baseChroma);
        pw.println(label + "_CHROMA_datas");
        PrgExporter.dumpFF14BandAsm(pw, pic, band, false);
        pw.println();
    }

    private static void dumpFF14BandAsm(PrintWriter pw, PictureInfo pic, int band, boolean luma) {
        int written = 0;
        StringBuilder line = new StringBuilder("BYTE ");
        for (int rowPair = 0; rowPair < 25; ++rowPair) {
            int y0 = rowPair * 8 + band * 2;
            for (int xChar = 0; xChar < 40; ++xChar) {
                int val;
                int px = xChar * 4;
                int idx1 = pic.getAuxColorsAt(px, y0)[0] & 0xFF;
                int idx2 = pic.getAuxColorsAt(px, y0)[1] & 0xFF;
                int aux1L = idx1 / 16 & 7;
                int aux1C = idx1 % 16 & 0xF;
                int aux2L = idx2 / 16 & 7;
                int aux2C = idx2 % 16 & 0xF;
                int n = val = luma ? (aux1L & 7) << 4 | aux2L & 7 : (aux2C & 0xF) << 4 | aux1C & 0xF;
                if (written == 8) {
                    pw.println(line);
                    line.setLength(0);
                    line.append("BYTE ");
                    written = 0;
                }
                if (written > 0) {
                    line.append(',');
                }
                line.append(PrgExporter.hex(val));
                ++written;
            }
        }
        if (written > 0) {
            pw.println(line);
        }
    }

    private static String hex(int v) {
        return String.format(Locale.ROOT, "$%02X", v & 0xFF);
    }

    private static void writePngPreview(PictureInfo pic, File outPrg) throws IOException {
        String baseName = outPrg.getName();
        int dot = baseName.lastIndexOf(46);
        String pngName = (dot > 0 ? baseName.substring(0, dot) : baseName) + ".png";
        File outPng = new File(outPrg.getParentFile(), pngName);
        BufferedImage img = PrgExporter.renderPreviewImage(pic);
        ImageIO.write((RenderedImage)img, "PNG", outPng);
    }

    private static BufferedImage renderPreviewImage(PictureInfo pic) {
        int w = 320;
        int h = 200;
        BufferedImage img = new BufferedImage(w, h, 1);
        for (int y = 0; y < 200; ++y) {
            int actY = Math.min(Math.max(y, 0), pic.getYs() - 1);
            int idx0 = pic.getFF15Line()[actY] & 0xFF;
            int idx1 = pic.getFF16Line()[actY] & 0xFF;
            for (int x = 0; x < 160; ++x) {
                int v = pic.getPixel2bpp(x, y) & 3;
                Color c = Plus4Palette.getColor((switch (v) {
                    case 0 -> idx0;
                    case 1 -> pic.getAuxColorsAt(x, y)[1] & 0xFF;
                    case 2 -> pic.getAuxColorsAt(x, y)[0] & 0xFF;
                    default -> idx1;
                }) & 0xFF);
                int rgb = c.getRGB();
                int sx = x * 2;
                img.setRGB(sx, y, rgb);
                img.setRGB(sx + 1, y, rgb);
            }
        }
        return img;
    }
}

