/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.model;

import java.util.Arrays;

public class PictureInfo {
    public static final int MaxX = 320;
    public static final int MaxY = 200;
    private int xs;
    private int ys;
    private int hires = 2;
    private ColorFormat colorFormat = ColorFormat.DFLI;
    private final byte[] FF15Line;
    private final byte[] FF16Line;
    private final byte[][] mc2bpp = new byte[200][160];
    private final byte[][] aux0_mc = new byte[40][25];
    private final byte[][] aux1_mc = new byte[40][25];
    private final byte[][][] aux0_dfli = new byte[40][25][4];
    private final byte[][][] aux1_dfli = new byte[40][25][4];
    private int curY = 0;
    private int currentPaint = 0;
    private int overridePaintIndex = -1;
    private int colmapPaintIndex2 = 17;
    private int colmapPaintIndex3 = 33;
    private int zoomPercent = 200;

    public PictureInfo(int xs, int ys) {
        this.xs = xs;
        this.ys = ys;
        this.FF15Line = new byte[ys];
        this.FF16Line = new byte[ys];
        Arrays.fill(this.FF15Line, (byte)0);
        Arrays.fill(this.FF16Line, (byte)1);
        for (int y = 0; y < 200; ++y) {
            Arrays.fill(this.mc2bpp[y], (byte)0);
        }
        for (int by = 0; by < 25; ++by) {
            for (int bx = 0; bx < 40; ++bx) {
                this.aux0_mc[bx][by] = 17;
                this.aux1_mc[bx][by] = 33;
                for (int s = 0; s < 4; ++s) {
                    this.aux0_dfli[bx][by][s] = (byte)(17 + s);
                    this.aux1_dfli[bx][by][s] = (byte)(33 + s);
                }
            }
        }
    }

    public int getXs() {
        return this.xs;
    }

    public int getYs() {
        return this.ys;
    }

    public int getHires() {
        return this.hires;
    }

    public void setHires(int h) {
        this.hires = h;
    }

    public ColorFormat getColorFormat() {
        return this.colorFormat;
    }

    public void setColorFormat(ColorFormat cf) {
        this.colorFormat = cf;
    }

    public byte[] getFF15Line() {
        return this.FF15Line;
    }

    public byte[] getFF16Line() {
        return this.FF16Line;
    }

    public int getPixel2bpp(int x, int y) {
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            return 0;
        }
        return this.mc2bpp[y][x] & 3;
    }

    public void setPixel2bpp(int x, int y, int v) {
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            return;
        }
        this.mc2bpp[y][x] = (byte)(v & 3);
    }

    public int[] getAuxColorsAt(int x, int y) {
        int bx = x / 4;
        int by = y / 8;
        if (this.colorFormat == ColorFormat.DFLI) {
            int sub = this.dfliVerticalBand(y);
            return new int[]{this.aux0_dfli[bx][by][sub] & 0xFF, this.aux1_dfli[bx][by][sub] & 0xFF};
        }
        return new int[]{this.aux0_mc[bx][by] & 0xFF, this.aux1_mc[bx][by] & 0xFF};
    }

    public void setAuxColorAt(int x, int y, int which, int palIndex) {
        int bx = x / 4;
        int by = y / 8;
        palIndex &= 0xFF;
        if (this.colorFormat == ColorFormat.DFLI) {
            int sub = this.dfliVerticalBand(y);
            if (which == 0) {
                this.aux0_dfli[bx][by][sub] = (byte)palIndex;
            } else {
                this.aux1_dfli[bx][by][sub] = (byte)palIndex;
            }
        } else if (which == 0) {
            this.aux0_mc[bx][by] = (byte)palIndex;
        } else {
            this.aux1_mc[bx][by] = (byte)palIndex;
        }
    }

    private int dfliVerticalBand(int y) {
        return (y & 7) >> 1;
    }

    public int getCurY() {
        return this.curY;
    }

    public void setCurY(int y) {
        this.curY = Math.max(0, Math.min(this.ys - 1, y));
    }

    public int getCurrentPaint() {
        return this.currentPaint;
    }

    public void setCurrentPaint(int idx) {
        this.currentPaint = idx & 3;
    }

    public int getOverridePaintIndex() {
        return this.overridePaintIndex;
    }

    public void setOverridePaintIndex(int idx) {
        this.overridePaintIndex = idx;
    }

    public int getColmapPaintIndex2() {
        return this.colmapPaintIndex2;
    }

    public void setColmapPaintIndex2(int idx) {
        this.colmapPaintIndex2 = idx & 0xFF;
    }

    public int getColmapPaintIndex3() {
        return this.colmapPaintIndex3;
    }

    public void setColmapPaintIndex3(int idx) {
        this.colmapPaintIndex3 = idx & 0xFF;
    }

    public int getZoomPercent() {
        return this.zoomPercent;
    }

    public void setZoomPercent(int p) {
        this.zoomPercent = Math.max(100, Math.min(800, p));
    }

    public static enum ColorFormat {
        NONE,
        NORMAL,
        DFLI;

    }
}

