/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.ui;

import com.medfli.model.PictureInfo;
import com.medfli.model.Plus4Palette;
import com.medfli.ui.RecolorBlockDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.IntConsumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EditorCanvas
extends JPanel {
    private final PictureInfo pic;
    private boolean showGrid = false;
    private boolean showDfliGrid = false;
    private boolean heatmapEnabled = false;
    private LineLockMode lineLockMode = LineLockMode.NONE;
    private int lineLockX = -1;
    private int lineLockY = -1;
    private Runnable heatmapListener;
    private final Deque<byte[]> undoStack = new ArrayDeque<byte[]>();
    private IntConsumer undoListener = null;
    private static final int UNDO_LIMIT = 3;
    private int brushSize = 1;
    private int hoverX = -1;
    private int hoverY = -1;
    private IntConsumer brushSizeListener = null;
    private Cursor defaultCursor;
    private Cursor eyedropperCursor;

    public void setBrushSizeListener(IntConsumer listener) {
        this.brushSizeListener = listener;
    }

    public void setHeatmapListener(Runnable r) {
        this.heatmapListener = r;
    }

    public boolean isHeatmapEnabled() {
        return this.heatmapEnabled;
    }

    public void toggleDfliGrid() {
        this.showDfliGrid = !this.showDfliGrid;
        this.repaint();
    }

    public void setBrushSize(int size) {
        int s = Math.max(1, Math.min(64, size));
        if (s != this.brushSize) {
            this.brushSize = s;
            if (this.brushSizeListener != null) {
                this.brushSizeListener.accept(this.brushSize);
            }
            this.repaint();
        }
    }

    public int getBrushSize() {
        return this.brushSize;
    }

    public EditorCanvas(final PictureInfo pic) {
        this.pic = pic;
        this.setBackground(Color.BLACK);
        this.setPreferredSize(this.calcPreferred());
        this.setFocusTraversalKeysEnabled(false);
        this.defaultCursor = this.getCursor();
        this.eyedropperCursor = this.createEyedropperCursor();
        MouseAdapter paint = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorCanvas.this.updateCursorForAlt(e);
                if (SwingUtilities.isLeftMouseButton(e) && e.isControlDown()) {
                    EditorCanvas.this.handleRecolorBlock(e);
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.isAltDown()) {
                    EditorCanvas.this.applyEyedropper(e);
                    EditorCanvas.this.updateHoverFromMouse(e.getX(), e.getY());
                    return;
                }
                EditorCanvas.this.pushUndo();
                EditorCanvas.this.applyPaint(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                EditorCanvas.this.updateCursorForAlt(e);
                if (SwingUtilities.isLeftMouseButton(e) && e.isAltDown()) {
                    EditorCanvas.this.applyEyedropper(e);
                    EditorCanvas.this.updateHoverFromMouse(e.getX(), e.getY());
                } else {
                    EditorCanvas.this.applyPaint(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                EditorCanvas.this.updateCursorForAlt(e);
                EditorCanvas.this.updateHoverFromMouse(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EditorCanvas.this.hoverY = -1;
                EditorCanvas.this.hoverX = -1;
                if (EditorCanvas.this.defaultCursor != null) {
                    EditorCanvas.this.setCursor(EditorCanvas.this.defaultCursor);
                }
                EditorCanvas.this.repaint();
            }
        };
        this.addMouseListener(paint);
        this.addMouseMotionListener(paint);
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(20, 0), "toggleGrid");
        am.put("toggleGrid", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorCanvas.this.showGrid = !EditorCanvas.this.showGrid;
                EditorCanvas.this.repaint();
            }
        });
        for (int k = 48; k <= 51; ++k) {
            final int idx = k - 48;
            im.put(KeyStroke.getKeyStroke("pressed " + (char)k), "ovr_on_" + idx);
            im.put(KeyStroke.getKeyStroke("released " + (char)k), "ovr_off_" + idx);
            am.put("ovr_on_" + idx, new AbstractAction(this){
                final /* synthetic */ EditorCanvas this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    pic.setOverridePaintIndex(idx);
                }
            });
            am.put("ovr_off_" + idx, new AbstractAction(this){
                final /* synthetic */ EditorCanvas this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (pic.getOverridePaintIndex() == idx) {
                        pic.setOverridePaintIndex(-1);
                    }
                }
            });
        }
        im.put(KeyStroke.getKeyStroke("pressed P"), "lock_vertical_on");
        im.put(KeyStroke.getKeyStroke("released P"), "lock_off_P");
        am.put("lock_vertical_on", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorCanvas.this.lineLockMode != LineLockMode.VERTICAL) {
                    EditorCanvas.this.lineLockMode = LineLockMode.VERTICAL;
                    EditorCanvas.this.lineLockX = -1;
                    EditorCanvas.this.lineLockY = -1;
                }
            }
        });
        im.put(KeyStroke.getKeyStroke("pressed L"), "lock_horizontal_on");
        im.put(KeyStroke.getKeyStroke("released L"), "lock_off_L");
        am.put("lock_horizontal_on", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorCanvas.this.lineLockMode != LineLockMode.HORIZONTAL) {
                    EditorCanvas.this.lineLockMode = LineLockMode.HORIZONTAL;
                    EditorCanvas.this.lineLockX = -1;
                    EditorCanvas.this.lineLockY = -1;
                }
            }
        });
        am.put("lock_off_P", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorCanvas.this.lineLockMode == LineLockMode.VERTICAL) {
                    EditorCanvas.this.lineLockMode = LineLockMode.NONE;
                    EditorCanvas.this.lineLockX = -1;
                    EditorCanvas.this.lineLockY = -1;
                }
            }
        });
        am.put("lock_off_L", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorCanvas.this.lineLockMode == LineLockMode.HORIZONTAL) {
                    EditorCanvas.this.lineLockMode = LineLockMode.NONE;
                    EditorCanvas.this.lineLockX = -1;
                    EditorCanvas.this.lineLockY = -1;
                }
            }
        });
        im.put(KeyStroke.getKeyStroke(72, 0), "toggleHeatmap");
        am.put("toggleHeatmap", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bl = EditorCanvas.this.heatmapEnabled = !EditorCanvas.this.heatmapEnabled;
                if (EditorCanvas.this.heatmapListener != null) {
                    EditorCanvas.this.heatmapListener.run();
                }
                EditorCanvas.this.repaint();
            }
        });
    }

    public void setUndoListener(IntConsumer listener) {
        this.undoListener = listener;
    }

    public int getUndoCount() {
        return this.undoStack.size();
    }

    public boolean performUndo() {
        if (this.undoStack.isEmpty()) {
            return false;
        }
        byte[] snap = this.undoStack.removeFirst();
        this.restoreSnapshot(snap);
        this.repaint();
        if (this.undoListener != null) {
            this.undoListener.accept(this.undoStack.size());
        }
        return true;
    }

    public void pushUndoSnapshot() {
        this.pushUndo();
    }

    private void pushUndo() {
        byte[] snap = this.createSnapshot();
        this.undoStack.addFirst(snap);
        while (this.undoStack.size() > 3) {
            this.undoStack.removeLast();
        }
        if (this.undoListener != null) {
            this.undoListener.accept(this.undoStack.size());
        }
    }

    private byte[] createSnapshot() {
        int W = 160;
        int H = 200;
        try {
            int x;
            int y;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(96400);
            DataOutputStream dos = new DataOutputStream(bos);
            for (y = 0; y < 200; ++y) {
                for (x = 0; x < 160; ++x) {
                    dos.writeByte(this.pic.getPixel2bpp(x, y));
                }
            }
            for (y = 0; y < 200; ++y) {
                dos.writeByte(this.pic.getFF15Line()[y]);
            }
            for (y = 0; y < 200; ++y) {
                dos.writeByte(this.pic.getFF16Line()[y]);
            }
            for (y = 0; y < 200; ++y) {
                for (x = 0; x < 160; ++x) {
                    int[] aux = this.pic.getAuxColorsAt(x, y);
                    dos.writeByte(aux[0] & 0xFF);
                    dos.writeByte(aux[1] & 0xFF);
                }
            }
            dos.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    private void restoreSnapshot(byte[] data) {
        int W = 160;
        int H = 200;
        try {
            int x;
            int y;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            for (y = 0; y < 200; ++y) {
                for (x = 0; x < 160; ++x) {
                    this.pic.setPixel2bpp(x, y, dis.readByte());
                }
            }
            for (y = 0; y < 200; ++y) {
                this.pic.getFF15Line()[y] = dis.readByte();
            }
            for (y = 0; y < 200; ++y) {
                this.pic.getFF16Line()[y] = dis.readByte();
            }
            for (y = 0; y < 200; ++y) {
                for (x = 0; x < 160; ++x) {
                    int a0 = dis.readByte() & 0xFF;
                    int a1 = dis.readByte() & 0xFF;
                    this.pic.setAuxColorAt(x, y, 0, a0);
                    this.pic.setAuxColorAt(x, y, 1, a1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Dimension calcPreferred() {
        double base = (double)this.pic.getZoomPercent() / 100.0;
        int w = (int)Math.round(160.0 * (2.0 * base));
        int h = (int)Math.round(200.0 * (1.0 * base));
        return new Dimension(Math.max(320, w), Math.max(200, h));
    }

    public void setZoomPercent(int p) {
        this.pic.setZoomPercent(p);
        this.setPreferredSize(this.calcPreferred());
        this.revalidate();
        this.repaint();
    }

    private void updateHoverFromMouse(int px, int py) {
        int w = this.getWidth();
        int h = this.getHeight();
        double base = (double)this.pic.getZoomPercent() / 100.0;
        double scaleX = 2.0 * base;
        double scaleY = 1.0 * base;
        int imgW = (int)Math.floor(160.0 * scaleX);
        int imgH = (int)Math.floor(200.0 * scaleY);
        int offX = (w - imgW) / 2;
        int offY = (h - imgH) / 2;
        if (px < offX || py < offY || px >= offX + imgW || py >= offY + imgH) {
            this.hoverY = -1;
            this.hoverX = -1;
            this.repaint();
            return;
        }
        int x = (int)Math.floor((double)(px - offX) / scaleX);
        int y = (int)Math.floor((double)(py - offY) / scaleY);
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            this.hoverY = -1;
            this.hoverX = -1;
            this.repaint();
            return;
        }
        if (this.lineLockMode != LineLockMode.NONE) {
            if (this.lineLockX == -1 && this.lineLockY == -1) {
                this.lineLockX = x;
                this.lineLockY = y;
            } else {
                if (this.lineLockMode == LineLockMode.VERTICAL) {
                    x = this.lineLockX;
                }
                if (this.lineLockMode == LineLockMode.HORIZONTAL) {
                    y = this.lineLockY;
                }
            }
        }
        this.hoverX = x;
        this.hoverY = y;
        this.repaint();
    }

    private void applyEyedropper(MouseEvent e) {
        int w = this.getWidth();
        int h = this.getHeight();
        double base = (double)this.pic.getZoomPercent() / 100.0;
        double scaleX = 2.0 * base;
        double scaleY = 1.0 * base;
        int imgW = (int)Math.floor(160.0 * scaleX);
        int imgH = (int)Math.floor(200.0 * scaleY);
        int offX = (w - imgW) / 2;
        int offY = (h - imgH) / 2;
        int px = e.getX();
        int py = e.getY();
        if (px < offX || py < offY || px >= offX + imgW || py >= offY + imgH) {
            return;
        }
        int x = (int)Math.floor((double)(px - offX) / scaleX);
        int y = (int)Math.floor((double)(py - offY) / scaleY);
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            return;
        }
        int v = this.pic.getPixel2bpp(x, y) & 3;
        switch (v) {
            case 0: {
                int idx = this.pic.getFF15Line()[y] & 0xFF;
                break;
            }
            case 1: {
                int idx = this.pic.getAuxColorsAt(x, y)[1] & 0xFF;
                try {
                    this.pic.setColmapPaintIndex3(idx);
                }
                catch (NoSuchMethodError noSuchMethodError) {}
                break;
            }
            case 2: {
                int idx = this.pic.getAuxColorsAt(x, y)[0] & 0xFF;
                try {
                    this.pic.setColmapPaintIndex2(idx);
                }
                catch (NoSuchMethodError noSuchMethodError) {}
                break;
            }
            default: {
                int idx = this.pic.getFF16Line()[y] & 0xFF;
            }
        }
        this.pic.setCurrentPaint(v);
        this.pic.setCurY(y);
        if (this.heatmapListener != null) {
            this.heatmapListener.run();
        }
        this.repaint();
    }

    private void handleRecolorBlock(MouseEvent e) {
        int w = this.getWidth();
        int h = this.getHeight();
        double base = (double)this.pic.getZoomPercent() / 100.0;
        double scaleX = 2.0 * base;
        double scaleY = 1.0 * base;
        int imgW = (int)Math.floor(160.0 * scaleX);
        int imgH = (int)Math.floor(200.0 * scaleY);
        int offX = (w - imgW) / 2;
        int offY = (h - imgH) / 2;
        int px = e.getX();
        int py = e.getY();
        if (px < offX || py < offY || px >= offX + imgW || py >= offY + imgH) {
            return;
        }
        int x = (int)Math.floor((double)(px - offX) / scaleX);
        int y = (int)Math.floor((double)(py - offY) / scaleY);
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            return;
        }
        int baseX = x / 4 * 4;
        int baseY = y & 0xFFFFFFFE;
        Window owner = SwingUtilities.getWindowAncestor(this);
        RecolorBlockDialog dlg = new RecolorBlockDialog(owner, this.pic, baseX, baseY, () -> {
            this.pushUndoSnapshot();
            if (this.heatmapListener != null) {
                this.heatmapListener.run();
            }
        });
        dlg.setVisible(true);
        this.repaint();
    }

    private void applyPaint(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.isControlDown()) {
            return;
        }
        if (e.isAltDown()) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        double base = (double)this.pic.getZoomPercent() / 100.0;
        double scaleX = 2.0 * base;
        double scaleY = 1.0 * base;
        int imgW = (int)Math.floor(160.0 * scaleX);
        int imgH = (int)Math.floor(200.0 * scaleY);
        int offX = (w - imgW) / 2;
        int offY = (h - imgH) / 2;
        int px = e.getX();
        int py = e.getY();
        if (px < offX || py < offY || px >= offX + imgW || py >= offY + imgH) {
            return;
        }
        int x = (int)Math.floor((double)(px - offX) / scaleX);
        int y = (int)Math.floor((double)(py - offY) / scaleY);
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            return;
        }
        if (this.lineLockMode != LineLockMode.NONE) {
            if (this.lineLockX == -1 && this.lineLockY == -1) {
                this.lineLockX = x;
                this.lineLockY = y;
            } else {
                if (this.lineLockMode == LineLockMode.VERTICAL) {
                    x = this.lineLockX;
                }
                if (this.lineLockMode == LineLockMode.HORIZONTAL) {
                    y = this.lineLockY;
                }
            }
        }
        this.hoverX = x;
        this.hoverY = y;
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.paintBrushAt(x, y);
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.cycleBrushAt(x, y);
        } else {
            return;
        }
        this.repaint();
    }

    private void paintBrushAt(int cx, int cy) {
        int size = this.brushSize;
        if (size <= 1) {
            this.paintSinglePixel(cx, cy);
            return;
        }
        int half = size / 2;
        int startX = cx - half;
        int startY = cy - half;
        int endX = startX + size - 1;
        int endY = startY + size - 1;
        for (int y = startY; y <= endY; ++y) {
            if (y < 0 || y >= 200) continue;
            for (int x = startX; x <= endX; ++x) {
                if (x < 0 || x >= 160) continue;
                this.paintSinglePixel(x, y);
            }
        }
    }

    private void cycleBrushAt(int cx, int cy) {
        int size = this.brushSize;
        if (size <= 1) {
            this.cycleSinglePixel(cx, cy);
            return;
        }
        int half = size / 2;
        int startX = cx - half;
        int startY = cy - half;
        int endX = startX + size - 1;
        int endY = startY + size - 1;
        for (int y = startY; y <= endY; ++y) {
            if (y < 0 || y >= 200) continue;
            for (int x = startX; x <= endX; ++x) {
                if (x < 0 || x >= 160) continue;
                this.cycleSinglePixel(x, y);
            }
        }
    }

    private void paintSinglePixel(int x, int y) {
        int paintIdx = this.pic.getOverridePaintIndex() != -1 ? this.pic.getOverridePaintIndex() : this.pic.getCurrentPaint();
        this.pic.setPixel2bpp(x, y, paintIdx);
        if (paintIdx == 2) {
            this.pic.setAuxColorAt(x, y, 0, this.pic.getColmapPaintIndex2());
        } else if (paintIdx == 1) {
            this.pic.setAuxColorAt(x, y, 1, this.pic.getColmapPaintIndex3());
        }
    }

    private void cycleSinglePixel(int x, int y) {
        int v = this.pic.getPixel2bpp(x, y);
        v = v + 1 & 3;
        this.pic.setPixel2bpp(x, y, v);
    }

    private void updateCursorForAlt(MouseEvent e) {
        if (this.eyedropperCursor == null || this.defaultCursor == null) {
            return;
        }
        if (e.isAltDown()) {
            this.setCursor(this.eyedropperCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    private Cursor createEyedropperCursor() {
        try {
            Image img = new ImageIcon(EditorCanvas.class.getResource("/com/medfli/ui/pipette.png")).getImage();
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            if (w <= 0 || h <= 0) {
                return Cursor.getPredefinedCursor(1);
            }
            Point hotSpot = new Point(0, h - 1);
            return Toolkit.getDefaultToolkit().createCustomCursor(img, hotSpot, "EyedropperCustom");
        }
        catch (Exception ex) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x;
        int cx;
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        double base = (double)this.pic.getZoomPercent() / 100.0;
        double scaleX = 2.0 * base;
        double scaleY = 1.0 * base;
        int imgW = (int)Math.floor(160.0 * scaleX);
        int imgH = (int)Math.floor(200.0 * scaleY);
        int offX = (w - imgW) / 2;
        int offY = (h - imgH) / 2;
        for (int y = 0; y < 200; ++y) {
            int actY = Math.min(Math.max(y, 0), this.pic.getYs() - 1);
            int idx0 = this.pic.getFF15Line()[actY] & 0xFF;
            int idx1 = this.pic.getFF16Line()[actY] & 0xFF;
            for (int x2 = 0; x2 < 160; ++x2) {
                int v = this.pic.getPixel2bpp(x2, y);
                Color c = Plus4Palette.getColor((switch (v) {
                    case 0 -> idx0;
                    case 1 -> this.pic.getAuxColorsAt(x2, y)[1];
                    case 2 -> this.pic.getAuxColorsAt(x2, y)[0];
                    default -> idx1;
                }) & 0xFF);
                int sx = offX + (int)Math.floor((double)x2 * scaleX);
                int sy = offY + (int)Math.floor((double)y * scaleY);
                int sw = Math.max(1, (int)Math.ceil((double)(x2 + 1) * scaleX) - (int)Math.floor((double)x2 * scaleX));
                int sh = Math.max(1, (int)Math.ceil((double)(y + 1) * scaleY) - (int)Math.floor((double)y * scaleY));
                g.setColor(c);
                g.fillRect(sx, sy, sw, sh);
            }
        }
        if (this.heatmapEnabled) {
            int ch = this.pic.getCurrentPaint() & 3;
            g.setColor(switch (ch) {
                case 0 -> new Color(0, 255, 255, 80);
                case 1 -> new Color(255, 165, 0, 80);
                case 2 -> new Color(0, 255, 0, 80);
                case 3 -> new Color(255, 0, 255, 80);
                default -> new Color(255, 255, 255, 80);
            });
            for (int y = 0; y < 200; ++y) {
                for (int x3 = 0; x3 < 160; ++x3) {
                    int v = this.pic.getPixel2bpp(x3, y) & 3;
                    if (v != ch) continue;
                    int sx = offX + (int)Math.floor((double)x3 * scaleX);
                    int sy = offY + (int)Math.floor((double)y * scaleY);
                    int sw = Math.max(1, (int)Math.ceil((double)(x3 + 1) * scaleX) - (int)Math.floor((double)x3 * scaleX));
                    int sh = Math.max(1, (int)Math.ceil((double)(y + 1) * scaleY) - (int)Math.floor((double)y * scaleY));
                    g.fillRect(sx, sy, sw, sh);
                }
            }
        }
        int cy0 = offY + (int)Math.floor((double)this.pic.getCurY() * (1.0 * base));
        int cy1 = offY + (int)Math.floor((double)(this.pic.getCurY() + 1) * (1.0 * base));
        int lineTop = cy0;
        int lineBottom = Math.max(cy0, cy1 - 1);
        g.setColor(Color.WHITE);
        g.drawLine(0, lineTop, this.getWidth() - 1, lineTop);
        if (lineBottom != lineTop) {
            g.drawLine(0, lineBottom, this.getWidth() - 1, lineBottom);
        }
        g.setColor(new Color(255, 255, 255, 80));
        g.drawRect(offX, cy0, imgW - 1, Math.max(1, cy1 - cy0) - 1);
        if (this.showGrid) {
            g.setColor(new Color(255, 255, 255, 120));
            for (cx = 0; cx <= 40; ++cx) {
                x = offX + (int)Math.floor((double)(cx * 4) * scaleX);
                g.drawLine(x, offY, x, offY + imgH - 1);
            }
            for (int cy = 0; cy <= 25; ++cy) {
                int y = offY + (int)Math.floor((double)(cy * 8) * scaleY);
                g.drawLine(offX, y, offX + imgW - 1, y);
            }
        }
        if (this.showDfliGrid) {
            g.setColor(new Color(255, 255, 200, 120));
            for (cx = 0; cx <= 40; ++cx) {
                x = offX + (int)Math.floor((double)(cx * 4) * scaleX);
                g.drawLine(x, offY, x, offY + imgH - 1);
            }
            for (int ry = 0; ry <= 100; ++ry) {
                int yy = ry * 2;
                int y = offY + (int)Math.floor((double)yy * scaleY);
                g.drawLine(offX, y, offX + imgW - 1, y);
            }
        }
        if (this.brushSize > 1 && this.hoverX >= 0 && this.hoverY >= 0) {
            int size = this.brushSize;
            int half = size / 2;
            int startX = this.hoverX - half;
            int startY = this.hoverY - half;
            int endX = startX + size - 1;
            int endY = startY + size - 1;
            startX = Math.max(0, startX);
            startY = Math.max(0, startY);
            endX = Math.min(159, endX);
            endY = Math.min(199, endY);
            int sx0 = offX + (int)Math.floor((double)startX * scaleX);
            int sy0 = offY + (int)Math.floor((double)startY * scaleY);
            int sx1 = offX + (int)Math.ceil((double)(endX + 1) * scaleX);
            int sy1 = offY + (int)Math.ceil((double)(endY + 1) * scaleY);
            int bw = Math.max(1, sx1 - sx0);
            int bh = Math.max(1, sy1 - sy0);
            g.setColor(new Color(255, 255, 255, 200));
            g.drawRect(sx0, sy0, bw - 1, bh - 1);
        }
    }

    private static enum LineLockMode {
        NONE,
        VERTICAL,
        HORIZONTAL;

    }
}

