/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.util;

public class ByteArrayWriter {
    private byte[] buf;
    private int pos;

    public ByteArrayWriter(int capacity) {
        this.buf = new byte[Math.max(capacity, 1024)];
        this.pos = 0;
    }

    public void writeByte(int b) {
        this.ensure(1);
        this.buf[this.pos++] = (byte)(b & 0xFF);
    }

    public void writeBytes(byte[] src) {
        this.ensure(src.length);
        System.arraycopy(src, 0, this.buf, this.pos, src.length);
        this.pos += src.length;
    }

    public void writeWordLE(int v) {
        this.writeByte(v & 0xFF);
        this.writeByte(v >>> 8 & 0xFF);
    }

    private void ensure(int add) {
        int need = this.pos + add;
        if (need > this.buf.length) {
            int nlen = Math.max(need, this.buf.length * 2);
            byte[] n = new byte[nlen];
            System.arraycopy(this.buf, 0, n, 0, this.pos);
            this.buf = n;
        }
    }

    public byte[] toArray() {
        byte[] out = new byte[this.pos];
        System.arraycopy(this.buf, 0, out, 0, this.pos);
        return out;
    }

    public int size() {
        return this.pos;
    }
}

