/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.ui;

import com.medfli.model.PictureInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.function.IntConsumer;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PaintChannelPanel
extends JPanel {
    private final PictureInfo pic;
    private final JButton[] btns = new JButton[4];
    private final IntConsumer onChange;
    private static final String[] LABELS = new String[]{"0 \u2013 FF15 (BG)", "1 \u2013 FF14 (AUX1)", "2 \u2013 FF14 (AUX0)", "3 \u2013 FF16 (MC1)"};

    public PaintChannelPanel(PictureInfo pic, IntConsumer onChange) {
        super(new GridLayout(2, 2, 8, 8));
        this.pic = pic;
        this.onChange = onChange;
        for (int i = 0; i < 4; ++i) {
            int channel = i;
            JButton b = new JButton(LABELS[i]);
            b.setFocusPainted(false);
            b.setFont(b.getFont().deriveFont(1, 14.0f));
            b.setPreferredSize(new Dimension(240, 40));
            b.addActionListener(e -> {
                pic.setCurrentPaint(channel);
                this.refreshButtons();
                if (onChange != null) {
                    onChange.accept(channel);
                }
            });
            this.btns[i] = b;
            this.add(b);
        }
        this.refreshButtons();
    }

    private void refreshButtons() {
        int cur = this.pic.getCurrentPaint();
        for (int i = 0; i < 4; ++i) {
            boolean active = i == cur;
            this.btns[i].setBackground(active ? new Color(140, 200, 140) : new Color(200, 200, 200));
            this.btns[i].setForeground(Color.BLACK);
            this.btns[i].setEnabled(true);
            this.btns[i].setText(LABELS[i]);
        }
    }
}

